//								EJEMPLO 21
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El teclado y el LCD.
//
//Haciendo uso de las rutinas incluidas en los ficheros KBD2.C y LCD2.C, se trata 
//de leer el teclado y, visualizar sobre el mdulo LCD  la tecla pulsada.
//
//El ejemplo pretende mostrar la interrupcin por cambio de estado en cualquiera de las lneas RB4-RB7 del PIC
//el sistema se mantiene en el modo SLEEP de bajo consumo y slo reacciona cuando tiene lugar la pulsacin
//de cualquier tecla.

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)
#include <kbd2.c>		//Incluir funciones de manejo del teclado
#include <lcd2.c>		//Incluir funciones de manejo del LCD

char tecla;
int	 temporal;

#int_rb				//Tratamiento de interrupcin por cambio de estado
tratamiento()
{	
	tecla=kbd_getc();		//Lee el teclado
	delay_ms(5);			//Temporizacin
	lcd_gotoxy(16,1);		//Posiciona el cursor
	lcd_putc(tecla);		//Visualiza la tecla pulsada
	set_tris_b(0b11110000);	//RB7-RB4 entradas, RB3-RB0 salidas	
	output_b(0x00);
	temporal=input_b();		//Repone el estado de la puerta B
	clear_interrupt(int_rb); //Repone el flag de interrupcin RB
}

main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	lcd_init();					//Secuencia de inicio del LCD
	printf(lcd_putc,"Se ha pulsado: "); //Mensaje en el LCD
	port_b_pullups(true);		//Activa cargas pull-up 
	set_tris_b(0xf0);			//RB0-RB3 salidas, RB4-RB7 entradas
	output_b(0x00);
	temporal=input_b();			//Repone el estado de la puerta A
	clear_interrupt(int_rb);	//Repone flag de interrupcin RB
	enable_interrupts(int_rb);	//Activa interrupcin RB
	enable_interrupts(global);	//Habilita interrupciones

	while(1)
	{	
		sleep();
	}
}	
